/* Soubor Kap04\01\Analyzer.java
   Program, ktery vypise vsechna ruzna slova, ktera se vyskytuji
   v textovem souboru.
   Cte standardni vstup. Vyuziva MojeIO, tzn. MojeIO.class 
   musi byt v nekterem z adresaru
   urcenych systemovou promennou CLASSPATH.

   pouziti: java Analyzer < jmenoSouboru

   Pouzitelne ve vsech verzich JDK, v JDK 5 ovsem dostaneme 
   varovani, ze pouziva typove nezabezpecene operace. 
   Toto varovani zatim ignorujeme.

   Neumi cist primo data z konzoly.
*/

// Hlavni a jedina trida programu
public class Analyzer
{
  static String oddelovace = " .,;!?";		// seznam znaku, ktere mohou oddelovat slova v textu

  
  int preskocOddelovace(String rad, int od) // rad: analyzovany radek, od: index, od ktereho se ma zacit
  {					    // Vraci: index, kde zacina nasledujici slovo, nebo -1, jsme-li na konci radku	
    if(od >= rad.length()) return -1;       // Jsme-li na konci radku, vrat -1
    while(oddelovace.indexOf(rad.charAt(od))>=0)
    {
     if(++od == rad.length()) return -1;
    }
    return od;
  }

  void analyzuj(String radek, java.util.ArrayList sezn) // radek: analyzovany radek, sezn: Kontejner, do kterho se majie slova ukladat
  {
    if(radek.equals(""))return;		// Prazdny radek nas nezajima
    int i = 0;				// Index znaku v radku
    StringBuffer slovo = null;		// Sem ulozime ziskane slovo
    i = preskocOddelovace(radek, i);	// Najdi zacatek dalsiho slova (-1 == konec radku)
    while(i >= 0)
    {
      slovo = new StringBuffer("");
      // Prenes nasledujici slovo do instance "slovo"
      while((i < radek.length()) && (oddelovace.indexOf(radek.charAt(i))==-1)) // Dokud to neni oddelovac
      {
        slovo.append(radek.charAt(i++));
      }
      // Uloz slovo do slovniku
      String s = new String(slovo);
      if(sezn.indexOf(s)==-1)sezn.add(new String(s));
      i = preskocOddelovace(radek, i);
    }
  }

  void beh() throws java.io.IOException		// Vlastni beh programu
  {
  	java.util.ArrayList slovnik = new java.util.ArrayList();
        String radek = MojeIO.inStr();	// Precti 1. radek

        while(radek != null)		// Dokud se cteni dari
        {
          radek = radek.trim();		// Odstran okrajove mezery
          analyzuj(radek, slovnik);
	  radek = MojeIO.inStr();	// Cti dalsi radek
        }
        System.out.println(slovnik);    // Vypis vysledek
  }

  public static void main(String[] s) throws java.io.IOException
  { // Vytvori instanci tridy Analyzer a spusti pro ni metodu beh()
      Analyzer a = new Analyzer();
      a.beh();
  }
}