/* Soubor Kap04\03\Analyzer.java
   Program, ktery vypise vsechna ruzna slova, ktera se vyskytuji
   v textovem souboru, a pocet jejich opakovani.
   Cte standardni vstup. Vyuziva MojeIO, tzn. MojeIO.class 
   musi byt v nekterem z adresaru
   urcenych systemovou promennou CLASSPATH.

   pouziti: java Analyzer < jmenoSouboru

   Neumi cist primo data z konzoly.
*/

// Trida, ktera slouzi k ukladani dvojic slovo - pocet vyskytu
class Dvojice 
{
  private int pocet;	// pocet vyskytu
  private String slovo; // retezec (slovo)
  public void pridej(){pocet++;}	// Zvetsi pocet vyskytu
  public Dvojice(String s, int i){pocet = i; slovo = s;}	// Konstruktory
  public Dvojice(String s){pocet = 1; slovo = s;}
  public boolean equals(Object x){return slovo.equals(((Dvojice)x).slovo);}// Predefinovana metoda pro provnavani dvojic - porovnava podle retezce
  public String toString(){return slovo + "(" + pocet + ")";}	// Predefinovana metoda pro konverzi na retezec
}

// Hlavni trida programu
public class Analyzer
{
  static String oddelovace = " .,;!?";		// seznam znaku, ktere mohou oddelovat slova v textu

  
  int preskocOddelovace(String rad, int od) // rad: analyzovany radek, od: index, od ktereho se ma zacit
  {					    // Vraci: index, kde zacina nasledujici slovo, nebo -1, jsme-li na konci radku	
    if(od >= rad.length()) return -1;       // Jsme-li na konci radku, vrat -1
    while(oddelovace.indexOf(rad.charAt(od))>=0)
    {
     if(++od == rad.length()) return -1;
    }
    return od;
  }

  void pridej(String slovo, java.util.ArrayList sezn) // Pridani noveho slova do seznamu 
  {						     // nebo zvyseni poctu vyskytu	
	Dvojice d = new Dvojice(slovo);			// Vytvor dvojici
	int i = sezn.indexOf(d);			// Zkus jin najit v seznamu
	if(i<0) 					// Kdyz tam neni
	{sezn.add(d);}					// tak ji pridej
	else						// jinak
	{
	 d = (Dvojice)sezn.get(i);			// si ji vyndej a 
	 d.pridej();					// zvetsi pocet vyskytu
	}
  }
  void analyzuj(String radek, java.util.ArrayList sezn) // radek: analyzovany radek, sezn: Kontejner, do kterho se majie slova ukladat
  {
    if(radek.equals(""))return;		// Prazdny radek nas nezajima
    int i = 0;				// Index znaku v radku
    StringBuffer slovo = null;		// Sem ulozime ziskane slovo
    i = preskocOddelovace(radek, i);	// Najdi zacatek dalsiho slova (-1 == konec radku)
    while(i >= 0)
    {
      slovo = new StringBuffer("");
      // Prenes nasledujici slovo do instance "slovo"
      while((i < radek.length()) && (oddelovace.indexOf(radek.charAt(i))==-1)) // Dokud to neni oddelovac
      {
        slovo.append(radek.charAt(i++));
      }
      // Uloz slovo do slovniku
      String s = new String(slovo);
      pridej(s, sezn);
      i = preskocOddelovace(radek, i);
    }
  }

  void beh() throws Exception		// Vlastni beh programu
  {
  	java.util.ArrayList slovnik = new java.util.ArrayList();
        String radek = MojeIO.inStr();	// Precti 1. radek

        while(radek != null)		// Dokud se cteni dari
        {
          radek = radek.trim();		// Odstran okrajove mezery
          analyzuj(radek, slovnik);
	  radek = MojeIO.inStr();	// Cti dalsi radek
        }
        System.out.println(slovnik);    // Vypis vysledek
  }

  public static void main(String[] s) throws Exception
  { // Vytvori instanci tridy Analyzer a spusti pro ni metodu beh()
      Analyzer a = new Analyzer();
      a.beh();
  }
}