/* Soubor Kap06\01\Konvertor.java
 * Trida pro konverzi celeho cisla na znakovy retezec 
 * umoznuje vytvorit ciselnou reprezentaci v ciselne soustave se zakladem 2 - 36
 * Cislice jsou vyjadreny znaky 0, 1, ... ,9, A, B, ... , Z
 *
 * Zaklad soustavy je parametrem konstruktoru, 
 * konvertovane cislo typu long je parametrem metody konverze.
 * Pouziti - konverze cisla x do sestnactkove soustavy:
 *
 * Konvertor k = new Konvertor(16);
 * string s = k.konverze(x)
 */

public class Konvertor {
  private long zaklad;  // Zaklad ciselne soustavy
  static String cislice = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; // Retezec obsahujici vsechny cislice, ktere se mohou vyskytnout v soustavach o zakladu od 2 do 36
  public String konverze(long n){
    StringBuffer s = new StringBuffer(""); // Zde budeme vytvaret znakovou reprezentaci cisla
    boolean zaporne = false;
    if(n==0)
    {                   // Je-li to nula, vrat retezec "0" (je stejny ve vsech soustavach)
      return "0";
    }
    if (n < 0)
    {
      zaporne = true;
      n = -n;
    };
    while(n != 0){
      s.append(cislice.charAt((int)(n%zaklad)));
      n /= zaklad;
    }
    if(zaporne)s.append('-');
    return new String(s.reverse());
  }

  public Konvertor(int baze) { // Parametrem je zaklad soustavy
	zaklad = baze;  
  }
  public static void main(String[] args) {
    //Konvertor k = new Konvertor(16);
    //System.out.println(k.konverze(-0xFFFFFFFFL));
    System.out.println((new Konvertor(2)).konverze(15));
  }
}