/* Soubor Kap09\01\Pokus.java
 * predvadi, ze se parametry primitivnich typu predavaji hodnotou,
 * ale parametry objektovych typu odkazem
 * (presneji, hodnotou se predava odkaz na objekt nebo pole)
 *
 * Trida Pokus obsahuje dve metody f(). Obe pocitaji faktorial 
 * a obe pritom meni hodnotu formalniho parametru.
 *
 * Jedna ma parametr typu int (zde nedojde ke zmene skutecneho parametru),
 * druha ma parametr typu MujInt, coz je objektovy typ zapouzdrujici
 * int. Jsou pro nej definovany metody, ktere umoznuji operace nasobeni, -- atd.
 * Pri volani teto metody se skutecny parametr zmeni.
 */

class MujInt {                  // Trida MujInt je objektovy typ zapouzdrujici int a operace s nim
  private int i;                // Ulozene cele cislo
  MujInt(int x){ i = x; }       // Konstruktor
  int getInt(){ return i; }     // Vrati ulozene cele cislo
  int minusMinus(){ return --i; }               // --
  boolean vetsiNez(int x){ return i > x; }      // Porovnani s celym cislem
  void setInt(int x){i = x;}                    // Zmena ulozene hodnoty
  void kratRovnaSe(MujInt n){ i *= n.getInt(); }// Operator *=
}

public class Pokus {		
  static MujInt f(MujInt n)     // Vypocet faktorialu pro typ MujInt
  {                             // Temer stejny jako vypocet pro int v nasledujici
    MujInt s;                   // metode f(int)
    for(s = new MujInt(1); n.vetsiNez(0); n.minusMinus())
      s.kratRovnaSe(n);
    return s;
  }

  static int f(int n)           // Vypocet faktorialu pro typ int
  {
    int s;
    for(s = 1; n > 0; n--) s *= n;
    return s;
  }

  public static void main(String[] args) {       // pokusy s predavanim parametru
    int x = 5, y = f(x);
    System.out.println("faktorial " + x + " je " + y);
    MujInt xx = new MujInt(5), yy = f(xx);
    System.out.println("faktorial " + xx.getInt() + " je " + yy.getInt());
  }
}