/*
   Soubor Kap4\07\Analyzer.java
   Opet pocitani slov v textovem souboru,
   ovsem tentokrat s pomoci vlastni implementace 
   jednosmerne zretezeneho seznamu zalozeneho 
   na parametrizovanych tridach.
   Pouziti stejne jako v predchozich pripadech.
   Vhodne pro JDK 5 a vyssi
*/

/** Prvek seznamu jako parametrizovana trida*/
class Prvek<T>
{
  T data = null;            // Slovo ulozene v prvku
  int pocet = 0;             // pocet vyskytu
  Prvek<T> dalsi = null;        // Odkaz na dalsi prvek seznamu
  Prvek(){}                  // Konstruktory
  Prvek(T s) {data = s; pocet = 1;}
  int obsahuje(T s) {return s.equals(data) ? pocet : 0;}
  void setDalsi(Prvek<T> q){dalsi = q;}
  Prvek<T> getDalsi(){return dalsi;}
  T getSlovo(){return data;}
  void zvetsiPocet(){pocet++;}
  int getPocet(){return pocet;}
}

/** Vlastni implementace seznamu jako parametrizovane tridy */
class Seznam<T>
{
  Prvek<T> hlava = null;
  void pridej(T slovo)
  {
    if(hlava == null)
    {
      hlava = new Prvek<T>(slovo);
    }
    else
    {
       Prvek<T> p = hlava, q = null;
       while(p != null)
       {
          if(p.obsahuje(slovo) > 0)
          {
            p.zvetsiPocet();
            return;
          }
          else
          {
            q = p;
            p = p.getDalsi();
          } // Konec if
       }    // konec while
       q.setDalsi(new Prvek<T>(slovo));
    }
  }

  void vypis()
  {
     Prvek<T> p = hlava;
     while(p != null)
     {
       System.out.println(p.getSlovo()+ " " + p.getPocet());
       p = p.getDalsi();
     }
  }
  
  void vyprazdni()
  {
	hlava = null;
  }

}

public class Analyzer
{
  static String oddelovace = " .,;!?";

  int preskocOddelovace(String rad, int od) // rad: analyzovany radek, od: index, od ktereho se ma zacit
  {					    // Vraci: index, kde zacina nasledujici slovo, nebo -1, jsme-li na konci radku	
    if(od >= rad.length()) return -1;       // Jsme-li na konci radku, vrat -1
    while(oddelovace.indexOf(rad.charAt(od))>=0)
    {
     if(++od == rad.length()) return -1;
    }
    return od;
  }



  void analyzuj(String radek, Seznam<String> sezn) // radek: analyzovany radek, sezn: Kontejner, do kterho se majie slova ukladat
  {
    if(radek.equals(""))return;		// Prazdny radek nas nezajima
    int i = 0;				// Index znaku v radku
    StringBuffer slovo = null;		// Sem ulozime ziskane slovo
    i = preskocOddelovace(radek, i);	// Najdi zacatek dalsiho slova (-1 == konec radku)
    while(i >= 0)
    {
      slovo = new StringBuffer("");
      // Prenes nasledujici slovo do instance "slovo"
      while((i < radek.length()) && (oddelovace.indexOf(radek.charAt(i))==-1)) // Dokud to neni oddelovac
      {
        slovo.append(radek.charAt(i++));
      }
      // Uloz slovo do slovniku
      String s = new String(slovo);
      sezn.pridej(s);
      i = preskocOddelovace(radek, i);
    }
  }


  void beh() throws Exception		// Vlastni beh programu
  {
    	Seznam<String> slovnik = new Seznam<String>();
        String radek = MojeIO.inStr();	// Precti 1. radek

        while(radek != null)		// Dokud se cteni dari
        {
          radek = radek.trim();		// Odstran okrajove mezery
          analyzuj(radek, slovnik);
	  radek = MojeIO.inStr();	// Cti dalsi radek
        }
        slovnik.vypis();    // Vypis vysledek

  }

  public static void main(String[] s) throws Exception
  { // Vytvori instanci tridy Analyzer a spusti pro ni metodu beh()
      Analyzer a = new Analyzer();
      a.beh();
  }
}