// Soubor Kap09\08\Pomoc.java
// Ukazka deklarace parametrizovanych metod
// Jen JDK 5


public class Pomoc
{
  // Najde prvek lezici uprostred pole typu T
  public static <T> T median(T[] x)
  {
    assert (x != null && x.length != 0); 
    return x[x.length / 2];
  }
  public static <T> void swap(int i, int j, T[] x)
  {
   assert i < x.length && j < x.length;    
   T a = x[i];
   x[i] = x[j];
   x[j] =a;
  } 

  // Vypocte prumer z prvku v danem poli
  public static <T extends Comparable> void sort(T[] x)
  {
    for(int i = 0; i < x.length; i++)
    {
      int min = i;
      for(int j = i+1; j < x.length; j++)
      {
         if(x[j].compareTo(x[min]) > 0) min = j;  // Najdi index nejmensiho
         if(min != i) swap(min, j, x);  // a prohod ho s prvnim v danem useku
      }
    } 
  }
}