/* Soubor Kap10\02\konvertor\Konvertor.java
 * Trida pro konverzi celeho cisla na znakovy retezec
 * umoznuje vytvorit ciselnou reprezentaci v ciselne soustave se zakladem 2 - 36
 * Cislice jsou vyjadreny znaky 0, 1, ... ,9, A, B, ... , Z
 *
 * UPRAVENA VERZE, KTERA PRI SPATNE ZADANEM ZAKLADU SOUSTAVY VYVOLA VYJIMKU
 * 
 * Zaklad soustavy je parametrem konstruktoru,
 * konvertovane cislo typu long je parametrem metody konverze.
 * Pouziti - konverze cisla x do sestnactkove soustavy:
 *
 * Konvertor k = new Konvertor(16);
 * string s = k.konverze(x)
 */

package konvertor;
public class Konvertor {
  private long zaklad;  // Zaklad ciselne soustavy
  static String cislice = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; // Retezec obsahujici vsechny cislice, ktere se mohou vyskytnout v soustavach o zakladu od 2 do 36
  public String konverze(long n){
    StringBuffer s = new StringBuffer(""); // Zde budeme vytvaret znakovou reprezentaci cisla
    boolean zaporne = false;
    if(n==0)
    {                   // Je-li to nula, vrat retezec "0" (je stejny ve vsech soustavach)
      return "0";
    }
    if (n < 0)
    {
      zaporne = true;
      n = -n;
    };
    while(n != 0){
      s.append(cislice.charAt((int)(n%zaklad)));
      n /= zaklad;
    }
    if(zaporne)s.append('-');
    return new String(s.reverse());
  }

  public Konvertor(int baze) { // Parametrem je zaklad soustavy
	if(baze < 2 || baze > 36) throw new WrongBaseException(""+baze);
        else zaklad = baze;
  }
  public static void main(String[] args) {
    System.out.println((new Konvertor(2)).konverze(15));
  }
}