/* Soubor Kap14\07\OknoVoleb.java
 * Okno voleb pro program Piskorky 2.1
 * Definuje konstanty udavajici rozmezi poctu tlacitek
 * Umoznuje zadat nejmene MINIMUM tlacitek, nejvyse HORNI_MEZ
 * Kombinovany seznam nabizi hodnoty od DOLNI_MEZ po HORNI_MEZ
 * Okno se po uzavreni nezrusi, pouze skryje
 * Vylepseno o filtr v okne pro volbu souboru
 */

package vokno;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class OknoVoleb extends JDialog
{                                             // Tlacitek je vzdy n x n
  public static final int DOLNI_MEZ = 10;     // Dolni mez hodnot zobrazovanych v kombu
  public static final int HORNI_MEZ = 20;     // Horni mez hodnot zobrazovanych v kombu
  public static final int MINIMUM = 5;        // Mene tlacitek nema smysl
  private boolean stiskOK = false;            // Uzavzel uzivatel okno stiskem OK?
  Object[] volby = null;                      // Pole voleb
  Object[] rozmery = null;                    // Pole hodnot pro kombo
  JButton ok = new JButton();                 // Tlacitka
  JButton storno = new JButton();
  JTextField obrazek1 = new JTextField();     // Editacni pole
  JTextField obrazek2 = new JTextField();
  JComboBox kombo = null;                     // Kombo (kombinovany seznam)
  JLabel canc1 = new JLabel();                // Napisy u komponent
  JLabel canc2 = new JLabel();
  JButton volic1 = new JButton();
  JButton volic2 = new JButton();

  public OknoVoleb(Frame vlastnik, Object[] vol) // Konstruktor
	{
		super(vlastnik, "Volby", true);
                volby = vol;
		setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
                    try {
                     jbInit();
                }
                catch(Exception e) {
                    e.printStackTrace();
                }
	}

  public OknoVoleb() {      // Konstruktor (nepouziva se, pozustatek prvniho napadu)
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public boolean getStiskOK(){return stiskOK;}  // Jak bylo okno uzavreno

  private void jbInit() throws Exception {    // Inicializace komponent
    this.getContentPane().setLayout(null);
    this.setResizable(false);
    //this.setModal(true);
    this.setSize(new Dimension(448, 300));
    ok.setText("OK");
    storno.setText("Storno");
    ok.setBounds(new Rectangle(30, 230, 110, 30));
    ok.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        ok_actionPerformed(e);
      }
    });
    storno.setBounds(new Rectangle(145, 230, 110, 30));
    storno.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        storno_actionPerformed(e);
      }
    });
    obrazek1.setBounds(new Rectangle(30, 35, 353, 30));
    obrazek1.setText((String)volby[0]);
    obrazek2.setText((String)volby[1]);
    obrazek2.setBounds(new Rectangle(30, 70, 353, 30));

    rozmery = new Object[HORNI_MEZ-DOLNI_MEZ+1];  // Priprava pole zobrazovanych hodnot pro kombo
    for(int i = DOLNI_MEZ; i <= HORNI_MEZ; i++){
      rozmery[i-DOLNI_MEZ] = new Integer(i);
    }

    kombo = new JComboBox(rozmery);
    kombo.setBounds(new Rectangle(30, 160, 87, 26));
    kombo.setEditable(true);

    kombo.setSelectedIndex(rozmery.length-1);

    canc1.setText("Soubor obsahujici znak pro 1., resp. 2. hrace:");
    canc1.setBounds(new Rectangle(30, 10, 354, 18));
    canc2.setText("Pocet rad a sloupcu hracich poli:");
    canc2.setBounds(new Rectangle(32, 126, 306, 17));
    volic1.setText("...");
    volic1.setBounds(new Rectangle(390, 36, 32, 30));
    volic2.setBounds(new Rectangle(391, 71, 32, 30));
    volic2.setText("...");
    volic1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        volba_Akce(e);
      }
    });
    volic2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        volba_Akce(e);
      }
    });
    this.getContentPane().add(ok, null);
    this.getContentPane().add(storno, null);
    this.getContentPane().add(obrazek1, null);
    this.getContentPane().add(obrazek2, null);
    this.getContentPane().add(kombo, null);
    this.getContentPane().add(canc1, null);
    this.getContentPane().add(canc2, null);
    this.getContentPane().add(volic1, null);
    this.getContentPane().add(volic2, null);
  }

  void storno_actionPerformed(ActionEvent e) {  // Odezva na stisk Storno
    stiskOK = false;                            // Nastav priznak
    obrazek1.setText((String)volby[0]);         // Obnov puvodni volby
    obrazek2.setText((String)volby[1]);
    kombo.setSelectedIndex(rozmery.length-1);
    this.setVisible(false);      // Skryj okno
  }

  void ok_actionPerformed(ActionEvent e) {// Odezva na stisk OK
    volby[0] = obrazek1.getText();    // Prenes volby
    volby[1] = obrazek2.getText();
    int n = Integer.parseInt(kombo.getSelectedItem().toString());
    n = Math.max(MINIMUM, n);// Pocet policek musi byt v rozmezi MINIMUM, HORNI_MEZ
    volby[2] = new Integer(Math.min(HORNI_MEZ, n));
    stiskOK = true;// Nastav priznak
    this.setVisible(false);// Skryj okno
  }

  // Vnitrni trida (jeji deklarace je vnorena do tridy OknoVoleb)
  // ** Trida filtru nemusi byt vnitrni **
  //
  // Trida filtru pro vyber souboru zobrazovanych v dialogovem okne JFileChooser
  // Musi byt potomkem tridy javax.swing.filechooser.FileFilter
  // a musi implementovat verejne pristupnou metodu
  // boolean accept(File f),
  // ktera rozhoduje, zda se soubor zobrazi
  // Metoda
  // public String getDescription()
  // vrati popis, ktery se zobrazi v radce pod jmenem souboru (Files of type)
  class Filtr extends javax.swing.filechooser.FileFilter
  {
    private String pripony = ".jpg .png .jpeg .gif"; // Akceptovane pripony
    public boolean accept(File soubor)
    {
      String pripona = getExtension(soubor);
      if(pripony.indexOf(pripona) != -1)return true;
      else return false;
    }
    private String getExtension(File soubor)  // Ziska priponu souboru
    {
      if(soubor != null)
      {
        String jmeno = soubor.getName();      // Ziska cele jmeno
        int i = jmeno.lastIndexOf('.');       // Teckou zacina pripona
        if (i > 0 && i < jmeno.length()-1)    // Vyjmi priponu a preved ji na mala pismena
         return jmeno.substring(i+1).toLowerCase();// zkus ji najit v retezci pripony
      }
      return "";                // Kdyz tam neni, vrat prazdny retezec
    }
    public String getDescription() // Vrati popis
    {
      return "Graficke soubory pro Javu";
    }
  }

  void volba_Akce(ActionEvent e){
   JTextField pole = e.getSource().equals(volic1)? obrazek1:obrazek2;

    File soubor = new File(".");

    JFileChooser vyberSoubor = new JFileChooser();
    vyberSoubor.setCurrentDirectory(soubor);
    vyberSoubor.setDialogTitle("Novy symbol hrace");
    vyberSoubor.setFileFilter(new Filtr());       // Nastav filtr
    int vysledek = vyberSoubor.showOpenDialog(this);
    if(vysledek == JFileChooser.APPROVE_OPTION)
    {
      pole.setText(vyberSoubor.getSelectedFile().getPath());
    }
  }
}