/* Soubor Kap15\01\Aplet1.java
 * Jednoduchy aplet, ktery podle stisknuteho prepinace
 * zobrazuje bud citat nebo jeho autora.
 * Oba texty cte z parametru apletu v HTML strance.
 * Pokud se parametry nepodari nacist, zobrazi implicitni text
 * "Chaos vladne i bez ministru." a jako autora uvede
 * "Bobbyho presvedceni".
 * Citat v parametrech apletu pochazi novorocniho pripitku Milose Formana 
 * (CT, silvestr 2000), 
 * citat pouzity v apletu jako implicitni je z knihy
 * Artura Blocha "Murphyho zakon", vydane nakladatelstvim Svoboda - Libertas
 * v Praze r. 1993.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Aplet1 extends JApplet {
  String citat = "Chaos vladne i bez ministru.";
  String autor = "Bobbyho presvedceni";
  JLabel napis = new JLabel();
  JPanel pomocny = new JPanel();
  ButtonGroup bg = new ButtonGroup();
  JRadioButton zobrazCitat = new JRadioButton();
  JRadioButton zobrazAutora = new JRadioButton();

  // Precte hodnotu parametru, a pokud neuspeje, vrati implicitni hodnotu
  public String getParameter(String key, String def) {
      return (getParameter(key) != null ? getParameter(key) : def);
  }

  public Aplet1() {  // Konstruktor
  }

  public void init() { // Inicializace
    try {
      String _citat = getParameter("VYROK", citat);
      String _autor =  getParameter("AUTOR", autor);
      citat = _citat;
      autor = _autor;
    }
    catch(Exception e) {}
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {   // Inicializace komponent
    this.setSize(new Dimension(400,300));
    JPanel panel = (JPanel)getContentPane();

    napis.setText(citat);
    napis.setFont(new java.awt.Font("Serif", Font.ITALIC | Font.BOLD, 32));
    napis.setForeground(Color.red);
    napis.setHorizontalAlignment(SwingConstants.CENTER);
    panel.add(napis, BorderLayout.CENTER);

    panel.add(pomocny, BorderLayout.SOUTH); 

    bg.add(zobrazCitat);		// Pridej prepinace do skupiny
    bg.add(zobrazAutora);
    pomocny.add(zobrazCitat);		// a vloz je na spodni panel
    pomocny.add(zobrazAutora);
    zobrazCitat.setText("Citat");
    zobrazCitat.setSelected(true);
    zobrazAutora.setText("Autor");
    ActionListener prijemce = new ActionListener() {// Instance prijemce udalosti
        public void actionPerformed(ActionEvent e) {
            stiskPrepinace(e);
        };
    };
    zobrazCitat.addActionListener(prijemce);
    zobrazAutora.addActionListener(prijemce);
  }

  public String getAppletInfo() {// Informace o apletu
    return "Muj prvni aplet";
  }

  protected void stiskPrepinace(ActionEvent e) { // Handler pro stisknuti
    if(e.getSource().equals(zobrazCitat))     // prepinace citat - autor
      napis.setText(citat);
    else
      napis.setText(autor);
  }
}