﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace seznam
{
    class Prvek<T>
    {
        private T data;
        private Prvek<T>? další;
        public Prvek(T _data, Prvek<T>? _další = null) 
        { 
            data = _data;
            další = _další;
        }
        public T getData()=> data;
        public void setData(T _data) => this.data = _data;
        public Prvek<T>? getDalší() => další;
        public void setDalší(Prvek<T> _další) => this.další = _další;
    }
    public class Seznam<T>
    {
        private Prvek<T>? hlava;
        private uint velikost = 0;
        public Seznam()
        {
            hlava = null;
        }
        public void VložNaZačátek(T co)
        {
            hlava = new Prvek<T>(co, hlava);
            velikost++;
        }

        public uint Velikost() => velikost;

        public void Výpis()
        {
            if (hlava == null)
            {
                System.Console.WriteLine("Seznam je prázdný");
            }
            else
            {
                var pom = hlava;
                while (pom != null)
                {
                    Console.Write(pom.getData() + ", ");
                    pom = pom.getDalší();
                }
                Console.WriteLine();
            }
        } 
    }
}
