package konvertor;

public class Konvertor 
{
    private short základ;
    private final String číslice = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    
    public Konvertor(short základ)
    {
        if(základ < 2 || základ > 36)
        {
            throw new IllegalArgumentException("Základ mimo rozsah: " + základ);
        }
        this.základ = základ;
    }
    
    public String konverze(long n)
    {
        var výsledek = new StringBuilder("");
        boolean záporné = n < 0;
        if(n == 0)
        {
            return "0";
        }
        if(záporné)
        {
            n = -n;
        }
        while(n != 0)
        {
            výsledek.append(číslice.charAt((int)(n % základ)));
            n /= základ;
        }
        if(záporné)výsledek.append('-');
        return výsledek.reverse().toString();
    }
}

