package první;

interface Funkce
{
    double funkce(double x);
}

class Výpočet implements Funkce
{

    @Override
    public double funkce(double x) 
    {
        return x*x;
    }
    
}

public class První 
{
    static void tabulka(double od, double po, int kolik, Funkce fun)
    {
        System.out.println("x            f(x)");
        System.out.println("-----------------");
        double delta  = (po - od)/(kolik - 1);
        for(int i = 0; i < kolik; i++)
        {
            double x = od + i * delta;
            System.out.println(x + "   " + fun.funkce(x));
        }
    }
    
    
    public static void main(String[] args) 
    {
        // Použití instance rozhraní
        // tabulka(0, 1, 11, new Výpočet());
        // Základní tvar lambda-výrazu
        // tabulka(0, 1, 11, (double x) -> {return x*x;});
        // zjednodušený tvar
        //tabulka(0, 1, 11, x ->  x*x );
        
        // Odkaz na metodu instance
//        Výpočet výpočet = new Výpočet();
//        tabulka(0, 1, 11, výpočet::funkce);
        // Jediná instance anonymní třídy implementující rozhraní
        tabulka(0, 1, 11, Math::sin);
        var f = new Funkce() {
            @Override
            public double funkce(double x) {
                return x*x;
            }
        };
        tabulka(0, 1, 11, f);
    }
    
    
}

