package sort2;

import java.util.*;

public class Sort2 
{
    static ArrayList<String> data = new ArrayList<>();
    static final String číslice = "0123456789";
    static final String textNápovědy = 
            """
            Filtr Sort
            Použití:
            SORT [způsob-řazení] < [vstupní-soubor] > [výstupní-soubor]
            Způsoby řazení: 
            -n podle čísel na počátku řádek
            -l lexikograficky
            """;
    
    static int počátečníČíslo(String txt)
    {
        try
        {
            int i = 0;
            while(txt.charAt(i) == ' ')
            {
                i++;
            }
            StringBuilder sb = new StringBuilder();
            while(číslice.indexOf(txt.charAt(i)) >= 0)
            {
                sb.append(txt.charAt(i++));
            }
            return Integer.parseInt(sb.toString());
        }
        catch(Exception e)
        {
            return 0;
        }
    }
    
    static void nápověda()
    {
        System.out.println("Nápověda");
        System.exit(0);
    }
    
    static Comparator<String> analýzaPříkazovéŘádky(String[] param)
    {
        if(param.length != 1)
        {
            nápověda();
        }
        if(param[0].equals("-n"))
        {
            return (txt1, txt2) -> počátečníČíslo(txt1) - počátečníČíslo(txt2);
        }
        if(param[0].equals("-l"))
        {
            return (txt1, txt2) -> txt1.compareTo(txt2);
        }
        nápověda();
        return null;
    }
    
    static void čteníDat()
    {
        try(Scanner vstup = new Scanner(System.in))
        {
           while(vstup.hasNextLine())
            {
                String txt = vstup.nextLine();
                data.add(txt);
            }
        }
// Předchozí kód znamená totéž co následující zakomentovaný        
//        Scanner vstup = new Scanner(System.in);
//        try
//        {
//            while(vstup.hasNextLine())
//            {
//                String txt = vstup.nextLine();
//                data.add(txt);
//            }
//        }
//        finally
//        {
//            vstup.close();
//        }
    }
    
    static void řazení(Comparator<String> komparátor)
    {
        data.sort(komparátor);
    }
    
    static void výpis()
    {
        for(var s : data)
        {
            System.out.println(s);
        }
    }
    
    public static void main(String[] args) 
    {
        System.out.println(textNápovědy);
//        var komparátor = analýzaPříkazovéŘádky(args);
//        čteníDat();
//        řazení(komparátor);
//        výpis();
       
    }
    
}
