package sort2;

import java.util.*;

class MůžeObsahovat
{
    private Comparator<String> komparátor;
    public MůžeObsahovat(Comparator<String> komparátor)
    {
        this.komparátor = komparátor;
    }
    
    public MůžeObsahovat()
    {
        this(null);
    }
    public boolean obsahuje()
    {
        return komparátor != null;
    }
    public Comparator<String> vrať() throws Exception
    {
        if(komparátor == null)
        {
            throw new Exception("Prázdná instance");
        }
        return komparátor;
    }
}

public class Sort2 
{
    static ArrayList<String> data = new ArrayList<>();
    static final String číslice = "0123456789";
    static final String TEXT_NÁPOVĚDY = 
            """
            Filtr Sort
            Použití:
            SORT [způsob-řazení] < [vstupní-soubor] > [výstupní-soubor]
            Způsoby řazení: 
            -n podle čísel na počátku řádek
            -l lexikograficky
            """;
    
    static int počátečníČíslo(String txt)
    {
        try
        {
            int i = 0;
            while(txt.charAt(i) == ' ')
            {
                i++;
            }
            StringBuilder sb = new StringBuilder();
            while(číslice.indexOf(txt.charAt(i)) >= 0)
            {
                sb.append(txt.charAt(i++));
            }
            return Integer.parseInt(sb.toString());
        }
        catch(Exception e)
        {
            return 0;
        }
    }
    
    static void nápověda()
    {
        System.out.println(TEXT_NÁPOVĚDY);
        //System.exit(0);
    }
    
    static MůžeObsahovat analýzaPříkazovéŘádky(String[] param)
    {
        if(param.length != 1)
        {
            return new MůžeObsahovat();
        }
        if(param[0].equals("-n"))
        {
            return new MůžeObsahovat((txt1, txt2) -> počátečníČíslo(txt1) - počátečníČíslo(txt2));
        }
        if(param[0].equals("-l"))
        {
            return new MůžeObsahovat((txt1, txt2) -> txt1.compareTo(txt2));
        }
        return new MůžeObsahovat();
    }
    
    static void čteníDat()
    {
        try(Scanner vstup = new Scanner(System.in))
        {
           while(vstup.hasNextLine())
            {
                String txt = vstup.nextLine();
                data.add(txt);
            }
        }
// Předchozí kód znamená totéž co následující zakomentovaný        
//        Scanner vstup = new Scanner(System.in);
//        try
//        {
//            while(vstup.hasNextLine())
//            {
//                String txt = vstup.nextLine();
//                data.add(txt);
//            }
//        }
//        finally
//        {
//            vstup.close();
//        }
    }
    
    static void řazení(Comparator<String> komparátor)
    {
        data.sort(komparátor);
    }
    
    static void výpis()
    {
        for(var s : data)
        {
            System.out.println(s);
        }
    }
    
    public static void main(String[] args) throws Exception 
    {
        var možnýKomparátor = analýzaPříkazovéŘádky(args);
        if(možnýKomparátor.obsahuje())
        {
            čteníDat();
            řazení(možnýKomparátor.vrať());
            výpis();
        }
        else
        {
            nápověda();
        }
    }
    
}
