package sort2;

import java.util.*;

// Analogie typu java.util.Optional
class MůžeObsahovat
{
    private Comparator<String> komparátor;
    public MůžeObsahovat(Comparator<String> komparátor)
    {
        this.komparátor = komparátor;
    }
    
    public MůžeObsahovat()
    {
        this(null);
    }
    public boolean obsahuje()
    {
        return komparátor != null;
    }
    public Comparator<String> vrať() throws Exception
    {
        if(komparátor == null)
        {
            throw new Exception("Prázdná instance");
        }
        return komparátor;
    }
}

public class Sort2 
{
    private static ArrayList<String> data = new ArrayList<>();
    private static final String číslice = "0123456789";
    private static final HashMap<String, Comparator<String>> mapa = new HashMap<String, Comparator<String>>();
    private static final String TEXT_NÁPOVĚDY = 
            """
            Filtr Sort
            Použití:
            SORT [způsob-řazení] < [vstupní-soubor] > [výstupní-soubor]
            Způsoby řazení: 
            -n podle čísel na počátku řádek
            -l lexikograficky
            """;
    private static void příprava()
    {
        mapa.put("-l", (txt1, txt2) -> txt1.compareTo(txt2));
        mapa.put("-n", (txt1, txt2) -> počátečníČíslo(txt1) - počátečníČíslo(txt2));
    }
    
    private static int počátečníČíslo(String txt)
    {
        try
        {
            int i = 0;
            while(txt.charAt(i) == ' ')
            {
                i++;
            }
            StringBuilder sb = new StringBuilder();
            while(číslice.indexOf(txt.charAt(i)) >= 0)
            {
                sb.append(txt.charAt(i++));
            }
            return Integer.parseInt(sb.toString());
        }
        catch(Exception e)
        {
            return 0;
        }
    }
    
    private static void nápověda()
    {
        System.out.println(TEXT_NÁPOVĚDY);
    }
    
    private static MůžeObsahovat analýzaPříkazovéŘádky(String[] param)
    {
        if((param.length != 1) || !mapa.containsKey(param[0]))
        {
            return new MůžeObsahovat();
        }
        return new MůžeObsahovat(mapa.get(param[0]));
    }
    
    private static void čteníDat()
    {
        try(Scanner vstup = new Scanner(System.in))
        {
           while(vstup.hasNextLine())
            {
                String txt = vstup.nextLine();
                data.add(txt);
            }
        }
    }
    
    private static void řazení(Comparator<String> komparátor)
    {
        data.sort(komparátor);
    }
    
    private static void výpis()
    {
        for(var s : data)
        {
            System.out.println(s);
        }
    }
    
    public static void main(String[] args) throws Exception 
    {
        var možnýKomparátor = analýzaPříkazovéŘádky(args);
        if(možnýKomparátor.obsahuje())
        {
            čteníDat();
            řazení(možnýKomparátor.vrať());
            výpis();
        }
        else
        {
            nápověda();
        }
    }
    
}
