package kontakty;

import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Program 
{
    private static ArrayList<Kontakt> kontakty = new ArrayList<>();
    
    private static void příprava()
    {
        kontakty.add(new Kontakt("Jan Vopička", "soukromý", "123456789"));
        kontakty.add(new Kontakt("Jan Vopička", "pracovní", "321456789"));
        kontakty.add(new Kontakt("Iva Modrá", "pracovní", "234567890"));
        kontakty.add(new Kontakt("Karel Mráz", "soukromý", "991122559"));
        kontakty.add(new Kontakt("Čeněk Bílý", "pracovní", "445511223"));
        kontakty.add(new Kontakt("Alena Vostrá", "pracovní", "258147369"));
        kontakty.add(new Kontakt("Alena Zelená", "soukromý", "554466997"));
        kontakty.add(new Kontakt("Helena Bílá", "pracovní", "445511223"));
    }
    
    static void výpisVšechKontaktů()
    {
        kontakty.stream()
                .forEachOrdered(kontakt -> System.out.println(kontakt));
    }
    
    static void upravSoukroméKontakty()
    {
        kontakty.stream()
                .filter(kontakt -> kontakt.typ.equals("soukromý"))
                .forEach(kontakt -> kontakt.telefon = "S" + kontakt.telefon);
    }
    
    static void upravAVypiš()   // Skončí výjimkou
    {
        java.util.stream.Stream<Kontakt> proud = kontakty.stream();
        proud.filter(kontakt -> kontakt.typ.equals("soukromý"))
                .forEach(kontakt -> kontakt.telefon = "S" + kontakt.telefon);
        // Nelze -- proud je již vyčerpán
        proud.forEach(kontakt -> System.out.println(kontakt));
    }
    
    public static void seřazenáJména()
    {
        kontakty.stream().map(kontakt -> kontakt.jméno)
                .distinct()
                .sorted()
                .forEach(kontakt -> System.out.println(kontakt));
    }
    
    public static void seřazenáJménaAbecedně()
    {
        kontakty.stream().map(kontakt -> kontakt.jméno)
                .distinct()
                .sorted(java.text.Collator.getInstance())
                .forEach(kontakt -> System.out.println(kontakt));
    }
    
    public static void seřazenáJménaAbecedněObráceně()
    {
        kontakty.stream().map(kontakt -> kontakt.jméno)
                .distinct()
                .sorted(java.text.Collator.getInstance().reversed())
                .forEach(kontakt -> System.out.println(kontakt));
    }
    
    public static OptionalInt součet(int n)
    {
        return IntStream.iterate(0, nn -> nn+1).limit(n).reduce((x, y) -> x+y);
    }
            
    
    public static void main(String[] args) 
    {
        příprava();
//        upravSoukroméKontakty();
//        výpisVšechKontaktů();
//        seřazenáJména();
//        seřazenáJménaAbecedně();
//        seřazenáJménaAbecedněObráceně();
        var oi = součet(5);
        if(oi.isPresent())
        System.out.println(oi.getAsInt());
    }
    
}
