package soubory;

import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;

public class Soubory 
{
    public static File vytvořPrázdnýSoubor(String jméno) throws IOException
    {
        File soubor = new File(jméno);
        if(soubor.exists())
        {
            soubor.delete();
        }
        soubor.createNewFile();
        return soubor;
    }
    
    private static void vypiš(String nadpis, File[] obsahAdresáře, Predicate<File> f)
    {
        System.out.println(nadpis + ":");
        for(var položka: obsahAdresáře)
        {
            if(f.test(položka))
            {
                System.out.println(položka.getAbsoluteFile());
            }  
        }
    }
    
    public static void vypišAdresář(String jméno)
    {
        File adresář = new File(jméno);
        if(adresář.isDirectory())
        {
            File[] obsahAdresáře = adresář.listFiles();
            vypiš("Adresáře", obsahAdresáře, File::isDirectory);
            vypiš("Soubory", obsahAdresáře, File::isFile);
        }
        else
        {
            System.out.println("Zadaná cesta " + jméno + " nepředstavuje adresář");
        }
    }
    
    public static void main(String[] args) throws IOException 
    {
        //vytvořPrázdnýSoubor("data.dta");
        vypišAdresář(".");
    }
    
}
