package grafickéobjekty;

import java.io.*;
import java.util.ArrayList;

public class Obrázek extends GrafickýObjekt 
{
    private ArrayList<GrafickýObjekt> složky = new ArrayList<>();
    public Obrázek()
    {
        super(0);
    }
    public void přidej(GrafickýObjekt go)
    {
        složky.add(go.kopie());
    }
    @Override
    public void nakresli()
    {
        for(var složka : složky)
        {
            složka.nakresli();
        }
    }
    
    public void ulož(String jméno) throws IOException
    {
        try(var výstup = new ObjectOutputStream(new FileOutputStream(jméno))) 
        {
            výstup.writeObject(this);
        }
    }
    
    public static Obrázek načti(String jméno) throws IOException, ClassNotFoundException
    {
        try(var vstup = new ObjectInputStream(new FileInputStream(jméno)))
        {
            return (Obrázek)vstup.readObject();
        }
            
    }
    
}
